VERSION 5.00
Object = "{3B7C8863-D78F-101B-B9B5-04021C009402}#1.2#0"; "RICHTX32.OCX"
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "comdlg32.ocx"
Begin VB.Form thaiallsystem 
   Caption         =   "Diag"
   ClientHeight    =   5145
   ClientLeft      =   165
   ClientTop       =   735
   ClientWidth     =   4185
   LinkTopic       =   "frmMain"
   ScaleHeight     =   5145
   ScaleWidth      =   4185
   StartUpPosition =   3  'Windows Default
   Begin MSComDlg.CommonDialog CommonDialog1 
      Left            =   3720
      Top             =   120
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
   End
   Begin RichTextLib.RichTextBox rtbMainText 
      Height          =   4935
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   3975
      _ExtentX        =   7011
      _ExtentY        =   8705
      _Version        =   393217
      ReadOnly        =   -1  'True
      ScrollBars      =   3
      TextRTF         =   $"frmMain.frx":0000
   End
   Begin VB.Menu Exit 
      Caption         =   "&Exit"
   End
   Begin VB.Menu Print 
      Caption         =   "&Print"
   End
   Begin VB.Menu DetailedSysInfo 
      Caption         =   "&Detailed System Information"
   End
   Begin VB.Menu About 
      Caption         =   "&About"
      WindowList      =   -1  'True
   End
End
Attribute VB_Name = "thaiallsystem"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
'-------------------------------------------------------------------------------------
Private Declare Function GetComputerName Lib "kernel32" Alias "GetComputerNameA" _
  (ByVal lpBuffer As String, nSize As Long) As Long
'-------------------------------------------------------------------------------------
Private Declare Function GetUserName Lib "advapi32.dll" Alias "GetUserNameA" _
  (ByVal lpBuffer As String, nSize As Long) As Long
'-------------------------------------------------------------------------------------
Private Type MEMORYSTATUS
        dwLength As Long
        dwMemoryLoad As Long
        dwTotalPhys As Long
        dwAvailPhys As Long
        dwTotalPageFile As Long
        dwAvailPageFile As Long
        dwTotalVirtual As Long
        dwAvailVirtual As Long
End Type

Private Declare Sub GlobalMemoryStatus Lib "kernel32" (lpBuffer As MEMORYSTATUS)
'-------------------------------------------------------------------------------------
Private Declare Function GetWindowsDirectory Lib "kernel32" Alias "GetWindowsDirectoryA" _
  (ByVal lpBuffer As String, ByVal nSize As Long) As Long
'-------------------------------------------------------------------------------------
Private Declare Function GetSystemDirectory Lib "kernel32" Alias "GetSystemDirectoryA" _
  (ByVal lpBuffer As String, ByVal nSize As Long) As Long
'-------------------------------------------------------------------------------------
Private Declare Function GetVersionEx Lib "kernel32" Alias _
"GetVersionExA" (lpVersionInformation As OSVERSIONINFO) As Long

Private Type OSVERSIONINFO
        dwOSVersionInfoSize As Long
        dwMajorVersion As Long
        dwMinorVersion As Long
        dwBuildNumber As Long
        dwPlatformId As Long
        szCSDVersion As String * 128      '  Maintenance string for PSS usage
End Type

'Windows version constants
Private Const WIN_VER_MAJ_9XNT4 = 4 'Windows 95/98/ME/NT4
Private Const WIN_VER_MAJ_NT3 = 3 'Windows NT3
Private Const WIN_VER_MAJ_2KXP = 5 'Windows NT5

Private Const WIN_VER_MIN_95 = 0    'Win95 minor
Private Const WIN_VER_MIN_98 = 10   'Win98 minor
Private Const WIN_VER_MIN_ME = 90   'WinME minor
Private Const WIN_VER_MIN_NT3 = 51  'WinNT3.51 minor
Private Const WIN_VER_MIN_NT4 = 0   'WinNT4 minor
Private Const WIN_VER_MIN_2K = 0    'Win2k minor
Private Const WIN_VER_MIN_XP = 1    'WinXP(Whistler) minor

'Platform ID
Private Const VER_PLATFORM_WIN32s = 0 'Win32s
Private Const VER_PLATFORM_WIN32_WINDOWS = 1 'Windows 9x
Private Const VER_PLATFORM_WIN32_NT = 2 'Windows NT
'-------------------------------------------------------------------------------------
Private Declare Function GetEnvironmentVariable Lib "kernel32" Alias _
  "GetEnvironmentVariableA" (ByVal lpName As String, ByVal lpBuffer As String, ByVal nSize As Long) As Long
'-------------------------------------------------------------------------------------
Private Declare Function GetDiskFreeSpace Lib "kernel32" Alias "GetDiskFreeSpaceA" _
  (ByVal lpRootPathName As String, lpSectorsPerCluster As Long, lpBytesPerSector As Long, _
  lpNumberOfFreeClusters As Long, lpTotalNumberOfClusters As Long) As Long

Public Enum enuDriveType
    DRIVE_UNKNOWN = 0
    DRIVE_NO_ROOT_DIR = 1
    DRIVE_REMOVABLE = 2     'floppy
    DRIVE_FIXED = 3         ' hard disk
    DRIVE_REMOTE = 4        ' network drive
    DRIVE_CDROM = 5
    DRIVE_RAMDISK = 6
End Enum

Private Declare Function GetDriveType Lib "kernel32" Alias "GetDriveTypeA" (ByVal nDrive As String) As Long

Private Declare Function WNetGetConnection Lib "mpr.dll" Alias "WNetGetConnectionA" (ByVal lpszLocalName As String, ByVal lpszRemoteName As String, cbRemoteName As Long) As Long

'-------------------------------------------------------------------------------------
Private Declare Function GetTickCount Lib "kernel32" () As Long
'-------------------------------------------------------------------------------------
Public Enum enuStartup
    Normal = 0
    Safe = 1
    SafeWithNetwork = 2
End Enum

Private Const SM_CXSCREEN = 0        ' Width of screen
Private Const SM_CYSCREEN = 1        ' Height of screen
Private Const SM_CXFULLSCREEN = 16   ' Width of window client area
Private Const SM_CYFULLSCREEN = 17   ' Height of window client area
Private Const SM_CYMENU = 15         ' Height of menu
Private Const SM_CYCAPTION = 4       ' Height of caption or title
Private Const SM_CXFRAME = 32        ' Width of window frame
Private Const SM_CYFRAME = 33        ' Height of window frame
Private Const SM_CXHSCROLL = 21      ' Width of arrow bitmap on horizontal scroll bar
Private Const SM_CYHSCROLL = 3       ' Height of arrow bitmap on horizontal scroll bar
Private Const SM_CXVSCROLL = 2       ' Width of arrow bitmap on vertical scroll bar
Private Const SM_CYVSCROLL = 20      ' Height of arrow bitmap on vertical scroll bar
Private Const SM_CXSIZE = 30         ' Width of bitmaps in title bar
Private Const SM_CYSIZE = 31         ' Height of bitmaps in title bar
Private Const SM_CXCURSOR = 13       ' Width of cursor
Private Const SM_CYCURSOR = 14       ' Height of cursor
Private Const SM_CXBORDER = 5        ' Width of window frame that cannot be sized
Private Const SM_CYBORDER = 6        ' Height of window frame that cannot be sized
Private Const SM_CXDOUBLECLICK = 36  ' Width of rectangle around the location of the first click. The
                                     '  second click must occur in the same rectangular location.
Private Const SM_CYDOUBLECLICK = 37  ' Height of rectangle around the location of the first click. The
                                     '  second click must occur in the same rectangular location.
Private Const SM_CXDLGFRAME = 7      ' Width of dialog frame window
Private Const SM_CYDLGFRAME = 8      ' Height of dialog frame window
Private Const SM_CXICON = 11         ' Width of icon
Private Const SM_CYICON = 12         ' Height of icon
Private Const SM_CXICONSPACING = 38  ' Width of rectangles the system uses to position tiled icons
Private Const SM_CYICONSPACING = 39  ' Height of rectangles the system uses to position tiled icons
Private Const SM_CXMIN = 28          ' Minimum width of window
Private Const SM_CYMIN = 29          ' Minimum height of window
Private Const SM_CXMINTRACK = 34     ' Minimum tracking width of window
Private Const SM_CYMINTRACK = 35     ' Minimum tracking height of window
Private Const SM_CXHTHUMB = 10       ' Width of scroll box (thumb) on horizontal scroll bar
Private Const SM_CYVTHUMB = 9        ' Width of scroll box (thumb) on vertical scroll bar
Private Const SM_DBCSENABLED = 42    ' Returns a non-zero if the current Windows version uses double-byte
                                     '  characters, otherwise returns zero
Private Const SM_DEBUG = 22          ' Returns non-zero if the Windows version is a debugging version
Private Const SM_MENUDROPALIGNMENT = 40
                                     ' Alignment of pop-up menus. If zero, left side is aligned with
                                     '  corresponding left side of menu-bar item. If non-zero, left side
                                     '  is aligned with right side of corresponding menu bar item
Private Const SM_MOUSEPRESENT = 19   ' Non-zero if mouse hardware is installed
Private Const SM_PENWINDOWS = 41     ' Handle of Pen Windows dynamic link library if Pen Windows is
                                     '  installed
Private Const SM_SWAPBUTTON = 23     ' Non-zero if the left and right mouse buttons are swapped
Private Const SM_CMOUSEBUTTONS = 43 'Number of mouse buttons
Private Const SM_CLEANBOOT = 67     'How did machine boot
Private Const SM_MOUSEWHEELPRESENT = 75
                                    'Is there a mousewheel?
Private Const SM_SHOWSOUNDS = 70    'Show visual feedback for sounds?
Private Const SM_NETWORK = 63       'Network present if LSB <> 0

Private Declare Function GetSystemMetrics Lib "user32" (ByVal nIndex As Long) As Long
'-------------------------------------------------------------------------------------

' Reg Key Security Options...
Const READ_CONTROL = &H20000
Const KEY_QUERY_VALUE = &H1
Const KEY_SET_VALUE = &H2
Const KEY_CREATE_SUB_KEY = &H4
Const KEY_ENUMERATE_SUB_KEYS = &H8
Const KEY_NOTIFY = &H10
Const KEY_CREATE_LINK = &H20
Const KEY_ALL_ACCESS = KEY_QUERY_VALUE + KEY_SET_VALUE + _
                       KEY_CREATE_SUB_KEY + KEY_ENUMERATE_SUB_KEYS + _
                       KEY_NOTIFY + KEY_CREATE_LINK + READ_CONTROL
                     
' Reg Key ROOT Types...
Const HKEY_LOCAL_MACHINE = &H80000002
Const ERROR_SUCCESS = 0
Const REG_SZ = 1                         ' Unicode nul terminated string
Const REG_DWORD = 4                      ' 32-bit number

Const gREGKEYSYSINFOLOC = "SOFTWARE\Microsoft\Shared Tools Location"
Const gREGVALSYSINFOLOC = "MSINFO"
Const gREGKEYSYSINFO = "SOFTWARE\Microsoft\Shared Tools\MSINFO"
Const gREGVALSYSINFO = "PATH"

Private Declare Function RegOpenKeyEx Lib "advapi32" Alias "RegOpenKeyExA" (ByVal hKey As Long, ByVal lpSubKey As String, ByVal ulOptions As Long, ByVal samDesired As Long, ByRef phkResult As Long) As Long
Private Declare Function RegQueryValueEx Lib "advapi32" Alias "RegQueryValueExA" (ByVal hKey As Long, ByVal lpValueName As String, ByVal lpReserved As Long, ByRef lpType As Long, ByVal lpData As String, ByRef lpcbData As Long) As Long
Private Declare Function RegCloseKey Lib "advapi32" (ByVal hKey As Long) As Long
'-------------------------------------------------------------------------------------

Private Function GetNetworked() As String

    Dim lngL As Long

    lngL = GetSystemMetrics(SM_NETWORK)

    If lngL <> 0 Then
        GetNetworked = "Network present = yes" + vbCrLf
    Else
        GetNetworked = "Network present = nos" + vbCrLf
    End If

End Function

Private Function GetLastBootState() As String

    Dim lngL As Long

    lngL = GetSystemMetrics(SM_CLEANBOOT)

    Select Case lngL
        Case Normal
            GetLastBootState = "Started in normal mode" + vbCrLf
        Case Safe
            GetLastBootState = "Started in safe mode" + vbCrLf
        Case SafeWithNetwork
            GetLastBootState = "Started in safe mode with network" + vbCrLf
        Case Else
            GetLastBootState = "Started in unknown operating mode" + vbCrLf
    End Select

End Function

Private Function GetWinVer() As String

    Dim strTemp As String
    Dim osInfo As OSVERSIONINFO
    Dim lngL As Long
    
    'Preset the size of the structure
    osInfo.dwOSVersionInfoSize = Len(osInfo)
    lngL = GetVersionEx(osInfo)
    
    If lngL <> 0 Then
        Select Case osInfo.dwMajorVersion
            Case WIN_VER_MAJ_9XNT4
                If osInfo.dwPlatformId = VER_PLATFORM_WIN32_WINDOWS Then
                    'Windows 9x Kernel, figure out which edition
                    If osInfo.dwMinorVersion = WIN_VER_MIN_95 Then
                        strTemp = "Windows95 "
                    ElseIf osInfo.dwMinorVersion = WIN_VER_MIN_98 Then
                        strTemp = "Windows98 "
                    ElseIf osInfo.dwMinorVersion = WIN_VER_MIN_ME Then
                        strTemp = "Windows ME "
                    Else
                        strTemp = "Unknown Windows 9x system "
                    End If
                Else
                    'NT4 kernel
                    If osInfo.dwMinorVersion = WIN_VER_MIN_NT4 Then
                        strTemp = "Windows NT 4 "
                    Else
                        strTemp = "Unknown NT 4-based version "
                    End If
               End If
               
            Case WIN_VER_MAJ_NT3
                    strTemp = "Windows NT 3." & osInfo.dwMinorVersion & " "
                
            Case WIN_VER_MAJ_2KXP
                If osInfo.dwMinorVersion = WIN_VER_MIN_2K Then
                    strTemp = "Windows 2000 "
                ElseIf osInfo.dwMinorVersion = WIN_VER_MIN_XP Then
                    strTemp = "Windows XP (Whistler) "
                Else
                    strTemp = "Unknown Windows NT 5 system "
                End If
            
            Case Else
                strTemp = "Unknown Windows system"
        End Select
            
        'Get service pack level information
        strTemp = strTemp + StripNullTerminator(osInfo.szCSDVersion) + vbCrLf
        strTemp = strTemp + "Windows Version Number = " + CStr(osInfo.dwMajorVersion) + "." _
        + CStr(osInfo.dwMinorVersion) + "." + CStr(osInfo.dwBuildNumber) + vbCrLf
    Else
        strTemp = "Unable to get version information. GetVersionEx returned " + lngL + vbCrLf
    End If
    
    GetWinVer = strTemp

End Function

Private Function GetWinDir() As String

    Dim boolRetVal As Boolean
    Dim lpBuffer As String
    Dim nSize As Long
    
    lpBuffer = Space(255)
    nSize = 254
    boolRetVal = GetWindowsDirectory(lpBuffer, nSize)
    
    GetWinDir = "Windows Directory = " + StripNullTerminator(lpBuffer) + vbCrLf

End Function

Private Function GetSysDir() As String

    Dim boolRetVal As Boolean
    Dim lpBuffer As String
    Dim nSize As Long
    
    lpBuffer = Space(255)
    nSize = 254
    boolRetVal = GetSystemDirectory(lpBuffer, nSize)
    
    GetSysDir = "System Directory = " + StripNullTerminator(lpBuffer) + vbCrLf

End Function

Private Function GetCompName() As String

    Dim boolRetVal As Boolean
    Dim lpBuffer As String
    Dim nSize As Long
    
    lpBuffer = Space(255)
    nSize = 254
    boolRetVal = GetComputerName(lpBuffer, nSize)
    
    GetCompName = "Computer Name = " + StripNullTerminator(lpBuffer) + vbCrLf
    
End Function

Private Function GetDomainName() As String

    Dim lpBuffer As String
    Dim nSize As Long
    Dim lngRetVal As Long
    
    lpBuffer = Space(255)
    nSize = 254
    lngRetVal = GetEnvironmentVariable("USERDOMAIN", lpBuffer, nSize)
    
    GetDomainName = "Domain Name = " + StripNullTerminator(lpBuffer) + vbCrLf
    
End Function

Private Function GetDriveInfo(strDrive As String) As String

    Dim lpSectorsPerCluster As Long
    Dim lpBytesPerSector As Long
    Dim lpNumberOfFreeClusters As Long
    Dim lpTotalNumberOfClusters As Long
    Dim lpRetVal As Long
    Dim strDriveType As String
    Dim lpBuffer As String
    Dim nSize As Long
    Dim lngL As Long
    
    Dim lpBytesPerCluster As Long
    Dim lpDriveSize As Long
    Dim lpDriveFreeSpace As Long
      
    lpRetVal = GetDriveType(strDrive)
    Select Case lpRetVal
        Case DRIVE_UNKNOWN
            strDriveType = "Drive type unknown"
        Case DRIVE_NO_ROOT_DIR
            strDriveType = "Drive has no root directory"
        Case DRIVE_REMOVABLE
            strDriveType = "Floppy / removable drive"
        Case DRIVE_FIXED
            strDriveType = "Fixed hard drive"
        Case DRIVE_REMOTE
            strDriveType = "Network drive: "
            'now get the mapped network drive
            lpBuffer = Space(255)
            nSize = 254
            lngL = WNetGetConnection(Left(strDrive, 2), lpBuffer, nSize)
            strDriveType = strDriveType + StripNullTerminator(lpBuffer)
        Case DRIVE_CDROM
            strDriveType = "CD-ROM drive"
        Case DRIVE_RAMDISK
            strDriveType = "RAM disk"
        Case Else
            strDriveType = "Unknown device"
    End Select

    lpRetVal = GetDiskFreeSpace(strDrive, lpSectorsPerCluster, lpBytesPerSector, lpNumberOfFreeClusters, lpTotalNumberOfClusters)
    lpBytesPerCluster = lpBytesPerSector * lpSectorsPerCluster
    lpDriveSize = lpBytesPerCluster * (lpTotalNumberOfClusters / 1024) / 1024
    lpDriveFreeSpace = lpBytesPerCluster * (lpNumberOfFreeClusters / 1024) / 1024

    If lpRetVal = 1 And lpDriveSize > 0 Then
        GetDriveInfo = strDrive + " drive - " + strDriveType + vbCrLf _
                    + vbTab + "Drive Size = " + CStr(lpDriveSize) + " MB" + vbCrLf _
                    + vbTab + "Free Space = " + CStr(lpDriveFreeSpace) + " MB" + vbCrLf + vbCrLf
    Else
        GetDriveInfo = ""
    End If

End Function

Private Function GetLogonServer() As String

    Dim lpBuffer As String
    Dim nSize As Long
    Dim lngRetVal As Long
    
    lpBuffer = Space(255)
    nSize = 254
    lngRetVal = GetEnvironmentVariable("LOGONSERVER", lpBuffer, nSize)
    
    GetLogonServer = "Logon Server Name = " + StripNullTerminator(lpBuffer) + vbCrLf
    
End Function


Private Function GetMemoryInfo() As String

    Dim msMemory As MEMORYSTATUS
    Dim lngTotalPhys As Long
    Dim lngAvailPhys As Long
    Dim lngTotalPageFile As Long
    Dim lngAvailPageFile As Long
    Dim lngTotalVirtual As Long
    Dim lngAvailVirtual As Long
    
    GlobalMemoryStatus msMemory
    lngTotalPhys = msMemory.dwTotalPhys / 1024 * (1 / 1024)
    lngAvailPhys = msMemory.dwAvailPhys / 1024 * (1 / 1024)
    lngTotalPageFile = msMemory.dwTotalPageFile / 1024 * (1 / 1024)
    lngAvailPageFile = msMemory.dwAvailPageFile / 1024 * (1 / 1024)
    lngTotalVirtual = msMemory.dwTotalPageFile / 1024 * (1 / 1024)
    lngAvailVirtual = msMemory.dwAvailPageFile / 1024 * (1 / 1024)
    
    GetMemoryInfo = "Memory Status:" + vbCrLf _
                    + vbTab + "Total RAM = " + CStr(lngTotalPhys) + "MB" + vbCrLf _
                    + vbTab + "Available RAM = " + CStr(lngAvailPhys) + "MB" + vbCrLf _
                    + vbTab + "Total PageFile = " + CStr(lngTotalPageFile) + "MB" + vbCrLf _
                    + vbTab + "Available PageFile = " + CStr(lngAvailPageFile) + "MB" + vbCrLf _
                    + vbTab + "Total Virtual Memory = " + CStr(lngTotalVirtual) + "MB" + vbCrLf _
                    + vbTab + "Available Virtual Memory = " + CStr(lngAvailVirtual) + "MB" + vbCrLf

End Function

Private Function GetTimeSinceReboot()

    'Returns the time since the machine was last restarted in format h:m:s
    Dim h As Long
    Dim m As Long
    Dim s As Long
    Dim l As Long
        
    l = GetTickCount()
    'GetTickCount returns number of milliseconds since last restart. divide by 1000 for seconds and convert to hours
    l = l / 1000
    'use integer division so we don't get rounding problems
    h = l \ 3600
    'Number of minutes over the hour
    m = (l - (h * 3600)) \ 60
    'Number of seconds over the minute
    s = l - (h * 3600 + m * 60)
    GetTimeSinceReboot = "Hours since reboot = " + Format(h, "00") + ":" & Format(m, "00") _
                        + ":" + Format(s, "00") + vbCrLf

End Function

Private Function GetUName() As String

    Dim lngRetVal As Long
    Dim lpBuffer As String
    Dim nSize As Long
    
    lpBuffer = Space(255)
    nSize = 254
    lngRetVal = GetUserName(lpBuffer, nSize)

    GetUName = "User Name = " + StripNullTerminator(lpBuffer) + vbCrLf

End Function

Private Sub About_Click()
    MsgBox "from : http://www.freevbcode.com/ShowCode.Asp?ID=3157"
    'Load frmAbout
    'frmAbout.Show

End Sub

Private Sub DetailedSysInfo_Click()
    
    StartSysInfo

End Sub

Private Sub Form_Load()

    Dim i As Integer

    rtbMainText.Text = rtbMainText.Text + GetUName
    rtbMainText.Text = rtbMainText.Text + GetCompName
    rtbMainText.Text = rtbMainText.Text + GetNetworked
    rtbMainText.Text = rtbMainText.Text + GetDomainName
    rtbMainText.Text = rtbMainText.Text + GetLogonServer
    rtbMainText.Text = rtbMainText.Text + GetTimeSinceReboot
    rtbMainText.Text = rtbMainText.Text + GetLastBootState
    rtbMainText.Text = rtbMainText.Text + vbCrLf
    
    rtbMainText.Text = rtbMainText.Text + GetWinVer
    rtbMainText.Text = rtbMainText.Text + GetWinDir
    rtbMainText.Text = rtbMainText.Text + GetSysDir
    rtbMainText.Text = rtbMainText.Text + vbCrLf
    
    rtbMainText.Text = rtbMainText.Text + GetMemoryInfo
    rtbMainText.Text = rtbMainText.Text + vbCrLf
  
    'scan all drive alphabets from A to Z
    For i = 1 To 26
        rtbMainText.Text = rtbMainText.Text + GetDriveInfo(Chr(Asc("A") + i - 1) + ":\")
    Next i
  
End Sub

Private Sub Form_Resize()

    rtbMainText.Height = thaiallsystem.Height - 900
    rtbMainText.Width = thaiallsystem.Width - 420
    
End Sub

Private Sub Print_Click()

    On Error GoTo Print_Error

    CommonDialog1.ShowPrinter
    
    Printer.FontName = "Courier New"
    Printer.FontSize = 12
    Printer.Print rtbMainText.Text

    Exit Sub
    
Print_Error:
    MsgBox "Printer Error"

End Sub

Private Function StripNullTerminator(lpBuffer As String) As String

    Dim i As Integer

    For i = 1 To 255
        If Asc(Mid(lpBuffer, i, 1)) = 0 Then
            lpBuffer = Left(lpBuffer, i - 1)
            Exit For
        End If
    Next i
    
    StripNullTerminator = lpBuffer

End Function

Public Sub StartSysInfo()
    On Error GoTo SysInfoErr
  
    Dim rc As Long
    Dim SysInfoPath As String
    
    ' Try To Get System Info Program Path\Name From Registry...
    If GetKeyValue(HKEY_LOCAL_MACHINE, gREGKEYSYSINFO, gREGVALSYSINFO, SysInfoPath) Then
    ' Try To Get System Info Program Path Only From Registry...
    ElseIf GetKeyValue(HKEY_LOCAL_MACHINE, gREGKEYSYSINFOLOC, gREGVALSYSINFOLOC, SysInfoPath) Then
        ' Validate Existance Of Known 32 Bit File Version
        If (Dir(SysInfoPath & "\MSINFO32.EXE") <> "") Then
            SysInfoPath = SysInfoPath & "\MSINFO32.EXE"
            
        ' Error - File Can Not Be Found...
        Else
            GoTo SysInfoErr
        End If
    ' Error - Registry Entry Can Not Be Found...
    Else
        GoTo SysInfoErr
    End If
    
    Call Shell(SysInfoPath, vbNormalFocus)
    
    Exit Sub
SysInfoErr:
    MsgBox "System Information Is Unavailable At This Time", vbOKOnly
End Sub

Public Function GetKeyValue(KeyRoot As Long, KeyName As String, SubKeyRef As String, ByRef KeyVal As String) As Boolean
    Dim i As Long                                           ' Loop Counter
    Dim rc As Long                                          ' Return Code
    Dim hKey As Long                                        ' Handle To An Open Registry Key
    Dim hDepth As Long                                      '
    Dim KeyValType As Long                                  ' Data Type Of A Registry Key
    Dim tmpVal As String                                    ' Tempory Storage For A Registry Key Value
    Dim KeyValSize As Long                                  ' Size Of Registry Key Variable
    '------------------------------------------------------------
    ' Open RegKey Under KeyRoot {HKEY_LOCAL_MACHINE...}
    '------------------------------------------------------------
    rc = RegOpenKeyEx(KeyRoot, KeyName, 0, KEY_ALL_ACCESS, hKey) ' Open Registry Key
    
    If (rc <> ERROR_SUCCESS) Then GoTo GetKeyError          ' Handle Error...
    
    tmpVal = String$(1024, 0)                             ' Allocate Variable Space
    KeyValSize = 1024                                       ' Mark Variable Size
    
    '------------------------------------------------------------
    ' Retrieve Registry Key Value...
    '------------------------------------------------------------
    rc = RegQueryValueEx(hKey, SubKeyRef, 0, _
                         KeyValType, tmpVal, KeyValSize)    ' Get/Create Key Value
                        
    If (rc <> ERROR_SUCCESS) Then GoTo GetKeyError          ' Handle Errors
    
    If (Asc(Mid(tmpVal, KeyValSize, 1)) = 0) Then           ' Win95 Adds Null Terminated String...
        tmpVal = Left(tmpVal, KeyValSize - 1)               ' Null Found, Extract From String
    Else                                                    ' WinNT Does NOT Null Terminate String...
        tmpVal = Left(tmpVal, KeyValSize)                   ' Null Not Found, Extract String Only
    End If
    '------------------------------------------------------------
    ' Determine Key Value Type For Conversion...
    '------------------------------------------------------------
    Select Case KeyValType                                  ' Search Data Types...
    Case REG_SZ                                             ' String Registry Key Data Type
        KeyVal = tmpVal                                     ' Copy String Value
    Case REG_DWORD                                          ' Double Word Registry Key Data Type
        For i = Len(tmpVal) To 1 Step -1                    ' Convert Each Bit
            KeyVal = KeyVal + Hex(Asc(Mid(tmpVal, i, 1)))   ' Build Value Char. By Char.
        Next
        KeyVal = Format$("&h" + KeyVal)                     ' Convert Double Word To String
    End Select
    
    GetKeyValue = True                                      ' Return Success
    rc = RegCloseKey(hKey)                                  ' Close Registry Key
    Exit Function                                           ' Exit
    
GetKeyError:      ' Cleanup After An Error Has Occured...
    KeyVal = ""                                             ' Set Return Val To Empty String
    GetKeyValue = False                                     ' Return Failure
    rc = RegCloseKey(hKey)                                  ' Close Registry Key
End Function


