/**
 * Sample React Native App
 * https://github.com/facebook/react-native
 *
 * @format
 * @flow strict-local
 */
import React from 'react';
import type {Node} from 'react';
import { SafeAreaView, ScrollView, StatusBar, StyleSheet, Text, useColorScheme, View, } from 'react-native';
import { Colors, DebugInstructions, Header, LearnMoreLinks, ReloadInstructions, } from 'react-native/Libraries/NewAppScreen';
const Section = ({children, title}): Node => {
  const isDarkMode = useColorScheme() === 'dark';
  return (
    <View style={styles.sectionContainer}>
      <Text style={[ styles.sectionTitle, { color: isDarkMode ? Colors.white : Colors.black, }, ]}>{title}</Text>
      <Text style={[ styles.sectionDescription, { color: isDarkMode ? Colors.light : Colors.dark, }, ]}>{children}</Text>
    </View>
  );
};
const styles = StyleSheet.create({
  sectionContainer: { marginTop: 5, paddingHorizontal: 5, },
  sectionTitle: { fontSize: 20, fontWeight: '600', },
  sectionDescription: { marginTop: 8, fontSize: 18, fontWeight: '400', },
  highlight: { fontWeight: '700', },  
  textLargeStyle: { fontSize: 20, textAlign: 'center', fontFamily: 'DancingScript-Regular', },  
});
const App: () => Node = () => {
  const isDarkMode = useColorScheme() === 'dark';
  const backgroundStyle = { backgroundColor: isDarkMode ? Colors.darker : Colors.lighter, };
  return (
    <SafeAreaView style={backgroundStyle}>
      <StatusBar barStyle={isDarkMode ? 'light-content' : 'dark-content'} />
      <ScrollView contentInsetAdjustmentBehavior="automatic" style={backgroundStyle}>
        <Header />
        <View style={{ backgroundColor: isDarkMode ? Colors.black : Colors.white, }}>
          <Section title="Step One">แก้ไขแฟ้ม <Text style={styles.highlight}>App.js</Text>  เพื่อเปลี่ยนหน้าจอ เมื่อกลับมาดูหน้าจอนี้จะพบการเปลี่ยนแปลงที่ได้แก้ไขไป{"\n"}				
<Text >ฟอนต์ (Font) 1</Text>{"\n"}
<Text style={{ fontFamily: "ChulabhornLikitText-Bold", fontWeight: 'normal', }}>ฟอนต์ (Font) 2</Text>{"\n"}
<Text style={{ fontFamily: "Kanit-ExtraBold", fontWeight: 'normal', }}>ฟอนต์ (Font) 3</Text>{"\n"}
<Text style={{ fontFamily: "Kanit-BlackItalic", fontWeight: 'normal', }}>ฟอนต์ (Font) 4</Text>{"\n"}
<Text style={{ fontFamily: "ChulabornLikitText-Regular", fontWeight: 'normal', }}>ฟอนต์ (Font) 5</Text>{"\n"}
<Text style={{ fontFamily: "Kanit-ThinItalic", fontWeight: 'normal', }}>ฟอนต์ (Font) 6</Text>{"\n"}
<Text style={{ fontFamily: "DancingScript-Bold", fontWeight: 'normal', }}>ฟอนต์ (Font) 7</Text>{"\n"}
<Text style={{ fontFamily: "DancingScript-Bold", fontWeight: 'normal', fontSize: 35, }}>DancingScript-Bold</Text>{"\n"}
<Text style={styles.textLargeStyle}>DancingScript-Regular</Text>{"\n"}
          </Section>
          <Section title="See Your Changes"><ReloadInstructions /></Section>
        </View>
      </ScrollView>
    </SafeAreaView>
  );
};
export default App;
/* LearnMoreLinks , DebugInstructions , https://aboutreact.com/custom-fonts-in-react-native/ */